<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil-square me-2"></i>Edit Sertifikat
    </h2>
    <a href="<?= base_url('admin/certificates') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/certificates/update/' . $certificate['id']) ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_sertifikat" class="form-label">Nama Sertifikat <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_sertifikat" name="nama_sertifikat" 
                       value="<?= old('nama_sertifikat', $certificate['nama_sertifikat']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="penerbit" class="form-label">Penerbit</label>
                <input type="text" class="form-control" id="penerbit" name="penerbit" 
                       value="<?= old('penerbit', $certificate['penerbit']) ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tanggal_terbit" class="form-label">Tanggal Terbit</label>
                <input type="date" class="form-control" id="tanggal_terbit" name="tanggal_terbit" 
                       value="<?= old('tanggal_terbit', $certificate['tanggal_terbit']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tanggal_expired" class="form-label">Tanggal Expired</label>
                <input type="date" class="form-control" id="tanggal_expired" name="tanggal_expired" 
                       value="<?= old('tanggal_expired', $certificate['tanggal_expired']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="nomor_sertifikat" class="form-label">Nomor Sertifikat</label>
                <input type="text" class="form-control" id="nomor_sertifikat" name="nomor_sertifikat" 
                       value="<?= old('nomor_sertifikat', $certificate['nomor_sertifikat']) ?>">
            </div>
        </div>

        <div class="mb-3">
            <label for="link_sertifikat" class="form-label">Link Sertifikat</label>
            <input type="url" class="form-control" id="link_sertifikat" name="link_sertifikat" 
                   value="<?= old('link_sertifikat', $certificate['link_sertifikat']) ?>" placeholder="https://...">
        </div>

        <div class="mb-3 position-relative">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi atau klik Generate AI untuk membuat otomatis..."><?= old('deskripsi', $certificate['deskripsi']) ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateCertificateDescription()">
                <i class="bi bi-magic" id="generateIcon"></i>
                <span id="generateText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="foto_sertifikat" class="form-label">Foto Sertifikat</label>
            <?php if ($certificate['foto_sertifikat']): ?>
                <div class="mb-2">
                    <small class="text-muted">File saat ini: <?= $certificate['foto_sertifikat'] ?></small>
                </div>
            <?php endif; ?>
            <input type="file" class="form-control" id="foto_sertifikat" name="foto_sertifikat" 
                   accept="image/jpeg,image/png,application/pdf">
            <small class="text-white">Format: JPG, PNG, PDF (Max: 5MB) - Kosongkan jika tidak ingin mengubah</small>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/certificates') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script src="<?= base_url('assets/js/ai-generator.js') ?>"></script>
<script>
// Initialize AI Generator UI for Certificates Edit
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill AI input when nama_sertifikat changes
    const namaSertifikat = document.getElementById('nama_sertifikat');
    if (namaSertifikat) {
        namaSertifikat.addEventListener('input', function() {
            const aiInput = document.getElementById('aiInput');
            if (aiInput && this.value) {
                aiInput.value = `Saya memperoleh sertifikat "${this.value}". Tolong buatkan deskripsi tentang kompetensi dan manfaat dari sertifikat ini.`;
            }
        });
    }
});
</script>